﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;

using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public class LabResultsInterpretationDB : DBUtils
    {
        public IEnumerable<LabResultInterpetation> GetInterpretationActivities(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            int STD_WKFACTIVITYSTS_ID,
            string PATIENT_LAST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            List<LabResultInterpetation> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_GetInterpretationActivities(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            STD_WKFACTIVITYSTS_ID,
                            PATIENT_LAST_NAME,
                            SORT_COLUMN,
                            START_ROW,
                            MAX_ROWS)
                        .ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public int GetInterpretationActivitiesCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            int STD_WKFACTIVITYSTS_ID,
            string PATIENT_LAST_NAME)
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_GetInterpretationActivitiesCount(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            STD_WKFACTIVITYSTS_ID,
                            PATIENT_LAST_NAME,
                            ref objReturn);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }

        public Dictionary<AddressType, Address> GetAddressesForWorkflow(string CURRENT_USER, int CURRENT_REGISTRY_ID, int? WKF_CASE_ID, int? WKF_CASE_ACTIVITY_ID)
        {
            const int EXPECTED_COUNT = 8;

            Dictionary<AddressType, Address> addressMap = new Dictionary<AddressType, Address>();

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    IMultipleResults sprocResults = dbContext.usp_getAddressesForWorkflow(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID, WKF_CASE_ACTIVITY_ID);

                    for (int idx = 0; idx < EXPECTED_COUNT; idx++)
                    {
                        var address = sprocResults.GetResult<Address>().FirstOrDefault();
                        if (address != null)
                            addressMap.Add(address.AddressType, address);
                    }

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return addressMap;
        }
    }
}
